using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;

using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;

public class DevConsoleScript : MonoBehaviour
{
    public List<string> log = new List<string>();
    public bool isVisible = false;
    public Text consoleLog;
    string outputText;
    public Text cl_showposText;
    public GameObject player;
    public bool cl_showposActive = false;
    public float numberImput = 1f;
    public GameObject wheatly;
    public int CLTimeMultiplied = 1;
    GameObject camera;
    public Material TriggerMaterial;
    bool showTriggersActive = false;
    int cl_showfps = 0;
    Text cl_showfpsText;

    // Start is called before the first frame update
    void Start()
    {
        camera = GameObject.Find("Camera");
        cl_showposText.transform.localScale = new Vector3(0, 0, 0);
        gameObject.transform.localScale = new Vector3(0, 0, 0);
        log.Add("Hello World!");
        updateConsoleLog();
        numberImput = 1f;
        TriggerMaterial.color = new Color(1, 1, 1, 0);
        cl_showfpsText = GameObject.Find("cl_showfps Text").GetComponent<Text>();
        if (File.Exists(@"C:\ProgramData\YouAreWhatYouEat\autoexec.txt"))
        {
            string[] autoexexSplit = File.ReadAllText(@"C:\ProgramData\YouAreWhatYouEat\autoexec.txt").Split(';');
            Debug.Log(autoexexSplit.Length);
            for (int i = 0; i < autoexexSplit.Length; i++)
            {
                runCommand(autoexexSplit[i]);
            }
        }
        else
        {
            File.Create(@"C:\ProgramData\YouAreWhatYouEat\autoexec.txt");
        }
    }

    // Update is called once per frame
    void Update()
    {
        if (isVisible) { gameObject.transform.localScale = new Vector3(1, 1, 1); }
        else { gameObject.transform.localScale = new Vector3(0, 0, 0); }
        cl_showposText.text = $"name: {Environment.UserName}{Environment.NewLine}pos: {player.transform.position.x}, {player.transform.position.y}, {player.transform.position.z}{Environment.NewLine}ang: {camera.transform.rotation.eulerAngles.x},{player.transform.rotation.eulerAngles.y},{camera.transform.localRotation.eulerAngles.z}";
        deltaTime += (Time.unscaledDeltaTime - deltaTime) * 0.1f;
    }
    float deltaTime = 0.0f;
    private void OnGUI()
    {
        float fps = 1.0f / deltaTime;
        switch (cl_showfps)
        {
            case 0:
                cl_showfpsText.text = "";
                break;
            case 1:
                cl_showfpsText.text = $"{Math.Round(fps, 2)}fps on {SceneManager.GetActiveScene().name}";
                break;
            default:
                break;
        }
    }
    public void addToConsoleLog(string thingToAdd)
    {
        log.Add(thingToAdd);
        updateConsoleLog();
        runCommand(thingToAdd);
    }
    public void updateConsoleLog()
    {
        outputText = "";
        for (int i = 0; i < log.Count; i++)
        {
            outputText = $"{outputText}{log[i]}{Environment.NewLine}";
        }
        consoleLog.text = "";
        consoleLog.text = outputText;
        if (log.Count > 93 * CLTimeMultiplied)
        {
            GameObject consoleLog = GameObject.Find("ConsoleLog");
            RectTransform CLRT = consoleLog.transform.GetComponent<RectTransform>();
            CLRT.sizeDelta = new Vector2(CLRT.rect.width, CLRT.rect.height + 2844.405f);
            CLTimeMultiplied++;
        }
    }
    public void runCommand(string command)
    {
        string[] commandSplit = command.Split(' ');
        switch (commandSplit[0])
        {
            case "cl_forwardspeed":
                {
                    try
                    {
                        if (float.Parse(commandSplit[1]) >= 0)
                        {
                            player.GetComponent<PlayerMovementScript>().speed = float.Parse(commandSplit[1]);

                            printOnConsole($"Set forwardspeed to {commandSplit[1]}");
                        }
                    }
                    catch
                    {
                        printOnConsole($"Please type in number following the command");
                    }
                }
                break;
            case "cl_showfps":
                {
                    switch(commandSplit[1])
                    {
                        case "0":
                            {
                                cl_showposText.transform.localPosition = new Vector3(-456, 264.9f, 0);
                                cl_showfps = 0;
                                printOnConsole("Set cl_showfps to 0");
                            }
                            break;
                        case "1":
                            {
                                cl_showposText.transform.localPosition = new Vector3(-456, 258.5f, 0);
                                cl_showfps = 1;
                                printOnConsole("Set cl_showfps to 1");
                            }
                            break;
                    }
                }
                break;
            case "cl_showpos":
                {
                    cl_showposActive = !cl_showposActive;
                    if (cl_showposActive)
                    {
                        cl_showposText.transform.localScale = new Vector3((float)0.22686, (float)0.22686, (float)0.22686);
                        printOnConsole("Set cl_showpos to 1");
                    }
                    else
                    {
                        cl_showposText.transform.localScale = new Vector3(0, 0, 0);
                        printOnConsole("Set cl_showpos to 0");
                    }
                }
                break;
            case "crosshair":
                {
                    if (commandSplit[1] == "0")
                    {
                        GameObject.Find("CrosshairImage").transform.localScale = new Vector3(0, 0, 0);
                        printOnConsole("set crosshair to 0");
                    }
                    else if (commandSplit[1] == "1")
                    {
                        GameObject.Find("CrosshairImage").transform.localScale = new Vector3(0.3f, 0.3f, 0.3f);
                        printOnConsole("Set crosshair to 1");
                    }
                    else
                    {
                        printOnConsole("Please type value of 0 or 1");
                    }
                }
                break;
            case "ent_create":
                {
                    switch (commandSplit[1])
                    {
                        case "npc_personality_core":
                            Instantiate(wheatly, GameObject.Find("CMDObjectEmpty").transform.position, Quaternion.Euler(0, 0, 0));

                            printOnConsole($"Summoned {commandSplit[1]}");
                            break;
                        case "npc_hagrid":
                            Instantiate(Resources.Load("HagridPrefab"), GameObject.Find("CMDObjectEmpty").transform.position, Quaternion.Euler(0, 0, 0));

                            printOnConsole($"Summoned {commandSplit[1]}");
                            break;
                        case "npc_geniusbar_employee":
                            Instantiate(Resources.Load("Genius"), GameObject.Find("CMDObjectEmpty").transform.position, Quaternion.Euler(270, 0, 0));

                            printOnConsole($"Summoned {commandSplit[1]}");
                            break;
                        default:
                            break;
                    }
                }
                break;
            case "exit":
                {
                    Application.Quit();
                }
                break;
            
            case "fog_enable":
                {
                    if(commandSplit[1] == "0")
                    {
                        GameObject.Find("DensityVolumes").transform.position = new Vector3(0,0,0);
                        printOnConsole("Set fog visibility to 0");
                       
                    }
                    else if(commandSplit[1] == "1")
                    {
                        GameObject.Find("DensityVolumes").transform.position = new Vector3(-1.48773623f, 438.417755f, 200.579468f);
                        printOnConsole("Set fog visibility to 1");
                    }
                    else
                    {
                        printOnConsole("Please type value of either 0, or 1");
                    }
                }
                break;
            case "host_timescale":
                {
                    if (float.Parse(commandSplit[1]) > 100)
                    {
                        printOnConsole("Value must be less than or equal to 100. Please type value again.");
                    }
                    else
                    {
                        player.GetComponent<MouseLook>().timescale = float.Parse(commandSplit[1]);
                        printOnConsole($"Set timescale to {commandSplit[1]}");
                    }
                }
                break;
            case "restart_level":
                {
                    SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex);
                }
                break;
            case "sensitivity":
                {
                    camera.GetComponent<MouseLook>().mouseSensitivity = float.Parse(commandSplit[1]);
                    printOnConsole($"Set player sensitivity to {commandSplit[1]}");
                }
                break;
            case "showtriggers":
                {
                    if (commandSplit[1] == "0")
                    {
                        showTriggersActive = false;
                        TriggerMaterial.color = new Color(1, 1, 1, 0);
                        printOnConsole("Set showtriggers to 0");
                    }
                    else if (commandSplit[1] == "1")
                    {
                        showTriggersActive = true;
                        TriggerMaterial.color = new Color(1, 1, 1, 0.3922f);
                        printOnConsole("Set showtriggers to 1");
                    }
                    else
                    {
                        printOnConsole("Please type value of 0, or 1");
                    }
                }
                break;
            case "showtriggers_toggle":
                {
                    showTriggersActive = !showTriggersActive;
                    if (showTriggersActive)
                    {
                        TriggerMaterial.color = new Color(1, 1, 1, 0.3922f);
                        printOnConsole("Set showtriggers to 1");
                    }
                    else
                    {

                        TriggerMaterial.color = new Color(255, 255, 255, 0);
                        printOnConsole("Set showtriggers to 0");
                    }
                }
                break;
            default:
                {
                    log.Add($"Invalid command: {command}");
                    updateConsoleLog();
                }
                break;
        }
    }
    void printOnConsole(string input)
    {
        log.Add(input);
        updateConsoleLog();
    }
}